<?php

/*
    Simple Flash Video Player
    =========================
    Display a video.
    
    License
    -------
    Copyright Josh Chesarek & Daniel G. Taylor 2008

    This file is part of Simple Flash Video.

    Simple Flash Video is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    Simple Flash Video is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simple Flash Video.  If not, see <http://www.gnu.org/licenses/>.
    
*/


	  
// Get the Arguments setup
$arguments = array();

// Put all of the arguments into an array
foreach ( (array) $attributes[1] as $key => $value ) 
{
    // Strip out legacy quotes
    $arguments[$value] = str_replace('"', '', $attributes[2][$key]);
}


$sfvOptions = array();

// Open the Config.xml file and read in the default Height and Width
$config_file_xml = dirname(__FILE__) . "/config.xml";
$xml = file_get_contents($config_file_xml) or die("Can't open remote files!");
$cur_tag = "";

function start_el_handler($parser,$name,$attribs)
{
    global $cur_tag;
    $cur_tag = $name;
}

function end_el_handler($parser,$name)
{

}

 // XML Entity Mandatory Escape Characters
function xmlentities($string) 
{
   return str_replace ( array ( '&', '"', "'", '<', '>', '�' ), array ( '&amp;' , '&quot;', '&apos;' , '&lt;' , '&gt;', '&apos;' ), $string );
}

function char_handler($parser,$data)
{
    global $cur_tag, $sfvOptions;
    $sfvOptions[$cur_tag] .= trim($data);
}

$parser = xml_parser_create();
xml_set_element_handler($parser, "start_el_handler", 'end_el_handler');
xml_set_character_data_handler($parser, "char_handler");
xml_parse($parser,$xml);

$height = $sfvOptions['HEIGHT'];  
$width = $sfvOptions['WIDTH'];

 
// Get the Arguments passed by plugin
$filename = trim($_GET["file_name"]); 
$filewidth = trim($_GET["width"]);
$fileheight = trim($_GET["height"]);
$longtail = trim($_GET['longtail']);
$arguments = $_GET;


// settings that we do not want passed through to the video.php
$plugin_settings = array("height", "width", "random", "embed", "longtail", "full_plugin_url", "plugin_url");

?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <title>Simple Flash Video Player</title>
    <style type="text/css">
	<?php if ($sfvOptions['REMOVE_PADDING'] == 'false') echo '.flashvideo { margin: 35px auto; text-align: center; }'?>
	
	body { margin: 0; }
       
	</style>
</head>

<body style="background-color: #333;">
<?php
 
// Write the video player using the provided and the config.xml variables using SWFObject
	$videoid = '1';
	
	$output ='<div id="mediaspace" class="flashvideo"><a href="http://www.adobe.com/go/getflashplayer"><img src="' . $sfvOptions['FULL_PLUGIN_URL'] . '/upgrade.png" alt="Upgrade Flash to watch video" /></a></div>';
	$output .= '<script type="text/javascript" src="' . dirname($_SERVER["PHP_SELF"]) . '/swfobject.js"></script>' . "\n";
	$output .= '<script type="text/javascript" src="' . dirname($_SERVER["PHP_SELF"]) . '/stats/simplestats.js"></script>';
	$output .= "\n" . '<span id="sfvcontainer' . $videoid . '" class="flashvideo"/>' . "\n";
	$output .= '<script type="text/javascript">' . "\n";
	$output .= 'var s' . $videoid . ' = new SWFObject("' . dirname($_SERVER["PHP_SELF"]) . '/mediaplayer.swf' . '","sfvideo' . $videoid . '","';
	
	if ($filewidth != $width) 
	{
		if($sfvOptions['REMOVE_PADDING'] == 'false')
		{
			$filewidth -= 90;
		}
		$output .= $filewidth; 
	}
	else
	{
		 $output .= $width;
	}

	if ($fileheight != $height) 
	{
		if($sfvOptions['REMOVE_PADDING'] == 'false')
		{
			$fileheight -= 70;
		}
		
		$output .= '","' . $fileheight;
	}
	else
	{
		 $output .= '","' .  $height; 
	}

	$output .= '","9.0.115");' . "\n";
	$output .= 's' . $videoid . '.addParam("allowfullscreen","true");' . "\n";
	$output .= 's' . $videoid . '.addParam("allowscriptaccess","always");' . "\n";
	$output .= 's' . $videoid . '.addParam("wmode","transparent");' . "\n";
	$output .= 's' . $videoid . '.addVariable("file", "' . $filename . '");' . "\n";
	$output .= 's' . $videoid . '.addVariable("config","'.dirname($_SERVER["PHP_SELF"]).'/config.xml");' . "\n";
	
	if ($fileheight != "")
	{ 
		$output .= 's' . $videoid . '.addVariable("height", "' . $fileheight . '");' . "\n";
	}
	
	if ($filewidth != "")
	{
		$output .= 's' . $videoid . '.addVariable("width", "' . $filewidth . '");' . "\n";
	}
	
	foreach($_GET as $name => $value)
	{
		if (array_search($name, $plugin_settings) === false)
		{
			if ($name == "vid_image") 
			{
				
			//echo "<p>" . "image" . ": " . $value . "</p>";
	    	$output .= 's' . $videoid . '.addVariable("image", "' . $value . '");' . "\n";

			}
			else
			{
				$name = str_replace("_", ".", $name);
				//echo "<p>" . $name . ": " . $value . "</p>";
	    		$output .= 's' . $videoid . '.addVariable("'. $name . '", "' . $value . '");' . "\n";
			}
		}
	}

	$output .= 's' . $videoid . '.write("mediaspace");' . "\n";

	$output .= '</script>' . "\n";


echo $output;

echo '</div>';

if (($sfvOptions['PLUGINS'] == 'ltas') || ($longtail == 'true'))
{
    echo '<script type="text/javascript" src="http://www.ltassrv.com/serve/api5.4.asp?' . xmlentities($sfvOptions['LONGTAILNUMBER']) . '"></script>';	
}
?>

<script type="text/javascript">
function getUpdate(typ, pr1, pr2, pid) { if (typ == "state" && pr1 == 'COMPLETED') { setTimeout("parent.Shadowbox.close()", 2000)} }
</script>


</body>
 
        	
</html>
